<?php $__env->startSection('title', translate('Messages')); ?>

<?php $__env->startSection('content'); ?>

    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-header-title"><?php echo e(translate('messages.conversation_list')); ?></h1>
        </div>
        <!-- End Page Header -->

        <div class="row g-3">
            <div class="col-lg-4 col-md-6">
                <!-- Card -->
                <div class="card h-100">
                    <div class="card-header border-0">
                        
                        <div class="conversation-custom-search__wrap w-100 position-relative">
                            <div class="input-group rounded overflow-hidden">
                                <input type="search" class="form-control border-inline-end-0" id="serach" placeholder="<?php echo e(translate('Search_by_name_or_phone')); ?>" aria-label="Username" aria-describedby="basic-addon1" autocomplete="off">
                                <button type="button" class="btn cursor-pointer p-0 border-0 input-group-prepend border-inline-end-0 bg--F0F2F5">
                                    <span class="input-group-text border-inline-end-0" id="basic-addon1"><i class="tio-search"></i></span>
                                </button>
                            </div>













                        </div>
                    </div>
                    <div class="px-4">
                        <ul class="nav nav-tabs mb-3 border-0 conversation-update">
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.message.list', ['tab'=> 'customer'])); ?>" class="nav-link <?php echo e($tab=='customer'?'active':''); ?>"><?php echo e(translate('Customer')); ?></a>
                            </li>
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.message.list', ['tab'=> 'vendor'])); ?>" class="nav-link <?php echo e($tab=='vendor'?'active':''); ?>"><?php echo e(translate('Restaurant')); ?></a>
                            </li>



                        </ul>
                    </div>

                    <!-- Body -->
                    <div class="card-body p-0 initial-19" id="conversation-list">
                        <?php echo $__env->make('admin-views.messages.data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                        
                    </div>
                    <!-- End Body -->

                </div>
                <!-- End Card -->
            </div>
            <div class="col-lg-8 col-md-6">
                <div id="admin-view-conversation" class="h-100 card">
                    <!-- <div class="card-body h-100 justify-content-center d-flex align-items-center text-center">
                        <h4 class="initial-29"><?php echo e(translate('messages.view_conversation')); ?>

                        </h4>
                    </div> -->
                    <div class="h-100 d-flex align-items-center justify-content-center">
                        <div class="text-center mt-3">
                            <img width="46" height="46" src="<?php echo e(dynamicAsset('/public/assets/admin/img/no-conversation.png')); ?>" alt="img" class="mb-2 opacity-75">
                            <p class="color-8a8a8a"><?php echo e(translate('messages.Please select a user to view the conversation.')); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
<script>
    "use strict";
    function viewAdminConvs(url, id_to_active, conv_id, sender_id) {
        var tab = getUrlParameter('tab');
        $('.customer-list').removeClass('conv-active');
            $('#' + id_to_active).addClass('conv-active');
            let new_url= "<?php echo e(route('admin.message.list')); ?>" + '?tab=' + tab+ '&conversation=' + conv_id+ '&user=' + sender_id;
            $.get({
                url: url,
                success: function(data) {
                    window.history.pushState('', 'New Page Title', new_url);
                    $('#admin-view-conversation').html(data.view);
                    conversationList();
                    // $(".conv-reply-form").removeClass('collapse');
                }
            });

        }
        let page = 1;
        $('#conversation-list').scroll(function() {
            if ($('#conversation-list').scrollTop() + $('#conversation-list').height() >= $('#conversation-list')
                .height()) {
                page++;
                loadMoreData(page);
            }
        });

        function loadMoreData(page) {
            var tab = getUrlParameter('tab');
            $.ajax({
                    url: "<?php echo e(route('admin.message.list')); ?>" + '?tab=' + tab+ '&page=' + page,
                    type: "get",
                    beforeSend: function() {

                    }
                })
                .done(function(data) {
                    if (data.html == " ") {
                        return;
                    }
                    $("#conversation-list").append(data.html);
                })
                .fail(function(jqXHR, ajaxOptions, thrownError) {
                    alert('server not responding...');
                });
        }

        function fetch_data(page, query) {
            var tab = getUrlParameter('tab');
            $.ajax({
                url: "<?php echo e(route('admin.message.list')); ?>"+ '?tab=' + tab + '&page=' + page + "&key=" + query,
                success: function(data) {
                    $('#conversation-list').empty();
                    $("#conversation-list").append(data.html);
                }
            })
        }

        $(document).on('keyup', '#serach', function() {
            let query = $('#serach').val();
            fetch_data(page, query);
        });

        document.getElementById('serach').addEventListener('input', function(event) {
            if (this.value === "") {
                let query = $('#serach').val();
                fetch_data(page, query);
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\alab projects\Helo Idly\resources\views/admin-views/messages/index.blade.php ENDPATH**/ ?>